<?php  
declare(strict_types=1);
session_start();

include 'konek.php';

function fetchCustomers(mysqli $conn): array {
    $stmt = $conn->prepare("SELECT * FROM pelanggan LEFT JOIN employee USING (employee_id) ORDER BY costumer_id DESC");
    $stmt->execute();
    return $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
}

$customers = fetchCustomers($conn);
?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Fixit - Explore new horizons</title>
    <link rel="stylesheet" type="text/css" href="profil.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
    <style>
        /* CSS */
        .btn {
        display: inline-block;       /* biar bisa di-set padding/width */
        padding: 0.6rem 1.2rem;      /* atur tinggi & lebar */
        background-color: #333;      /* warna dasar */
        color: #fff;                 /* warna teks */
        text-decoration: none;       /* hilangin underline */
        border-radius: 4px;          /* sudut melengkung */
        font-weight: 600;            /* teks agak tebal */
        transition: background 0.2s; /* efek hover halus */
        }

        .btn:hover {
        background-color: #555;      /* sedikit lebih terang pas hover */
        }
    </style>
</head>
<body>
    <header>
        <div class="container">
            <h1><a href="database.php">FIXIT</a></h1>
            <ul>
                <li><a href="admin-testdrive.php">Test Drive</a></li>
                <li><a href="admin.php">Customers</a></li>
                <li><a href="supplier.php">Supplier</a></li>
                <!-- <li><a href="admin-logout.php">Logout</a></li> -->
            </ul>
        </div>
    </header>

    <div class="section">
        <div class="container">
            <h3>Data Customer</h3>
            <div class="box">
                <!-- <p><a href="admin-add-customer.php">Add Customer data</a></p><br> -->
                 <p style="padding-bottom: 12px;"><a href="admin-add-customer.php" class="btn">Add Customer data</a></p>
                <table border="1" cellspacing="0" class="table">
                    <thead>
                        <tr class="tr">
                            <th>No</th>
                            <th>Customer ID</th>
                            <th>Customer Name</th>
                            <th>Customer Phone Number</th>
                            <th width="20px">Customer Email</th>
                            <th>Customer Address</th>
                            <th>Employee ID</th>
                            <th width="100px">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($customers as $index => $row): ?>
                        <tr>
                            <td><?= htmlspecialchars((string) ($index + 1)) ?></td>
                            <td><?= htmlspecialchars((string) $row['costumer_id']) ?></td>
                            <td><?= htmlspecialchars((string) $row['costumer_name']) ?></td>
                            <td><?= htmlspecialchars((string) $row['costumer_num']) ?></td>
                            <td><?= htmlspecialchars((string) $row['costumer_email']) ?></td>
                            <td><?= htmlspecialchars((string) $row['costumer_address']) ?></td>
                            <td><?= htmlspecialchars((string) $row['employee_id']) ?></td>
                            <td style="text-align: center;">
                                <a href="admin-edit-costumer.php?id=<?= urlencode((string) $row['costumer_id']) ?>"><i class="fas fa-edit"></i> </a> || <a href="delete.php?idc=<?= urlencode((string) $row['costumer_id']) ?>" onclick="return confirm('Are you sure?')"><i class="fas fa-trash-alt"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <footer>
        <div class="container">
            <small>Copyright &copy; 2023 - FIXIT.</small>
        </div>
    </footer>
</body>
</html>
