<?php  
    session_start();
    // ini untuk menyambungkan ke file lain
    include 'konek.php';

    // Sanitize input from GET request to prevent SQL Injection
    $vehicle_id = $_GET['id'] ?? '';

    // Prepared statement untuk menghindari SQL Injection
    if ($stmt = $conn->prepare("SELECT * FROM admin WHERE vehicle_id = ?")) {
        $stmt->bind_param("s", $vehicle_id);
        $stmt->execute();
        $result = $stmt->get_result();
        $a = $result->fetch_object();
        $stmt->close();
    }
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Fixit - Explore new horizons</title>
    <link rel="stylesheet" type="text/css" href="profil.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>

    <style>
        /* CSS */
        .btn {
        display: inline-block;       /* biar bisa di-set padding/width */
        padding: 0.6rem 1.2rem;      /* atur tinggi & lebar */
        background-color: #333;      /* warna dasar */
        color: #fff;                 /* warna teks */
        text-decoration: none;       /* hilangin underline */
        border-radius: 4px;          /* sudut melengkung */
        font-weight: 600;            /* teks agak tebal */
        transition: background 0.2s; /* efek hover halus */
        }

        .btn:hover {
        background-color: #555;      /* sedikit lebih terang pas hover */
        }
    </style>
</head>

<body>
    <!-- header -->
    <header>
        <div class="container">
            <h1><a href="database.php">FIXIT</a></h1>
            <ul>
			<li><a href="admin-testdrive.php">Test Drive</a></li>
                <li><a href="admin.php">Customers</a></li>
                <li><a href="supplier.php">Supplier</a></li>
            </ul>
        </div>
    </header>

    <!-- container -->
    <div class="section">
        <div class="container">
            <h3>Data Test Drive Customer</h3>
            <div class="box">
                <!-- <p><a href="admin-add-testdrive.php">Add Data Test Drive</a></p><br> -->
                 <!-- HTML -->
                <p style="padding-bottom: 12px;">
                 <a href="admin-add-testdrive.php" class="btn" >Add Data Test Drive</a>
                </p>
                <table border="1" cellspacing="0" class="table">
                    <thead>
                        <tr class="tr">
                            <th>No</th>
                            <th>Testdrive ID</th>
                            <th>Vehicle ID</th>
                            <th>Customer ID</th>
                            <th width="200px">Review</th>
                            <th>Location</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            // untuk memulai data dari angka 1
                            $no = 1;
                            // memilih data sesuai dari database
                            if ($stmt = $conn->prepare("SELECT * FROM test_drive LEFT JOIN admin USING (vehicle_id) ORDER BY testdrive_id DESC")) {
                                $stmt->execute();
                                $result = $stmt->get_result();
                                while ($row = $result->fetch_assoc()) {
                        ?>
                        <tr>
                            <td><?php echo $no++ ?></td>
                            <td><?php echo htmlspecialchars($row['testdrive_id']) ?></td>
                            <td><?php echo htmlspecialchars($row['vehicle_id']) ?></td>
                            <td><?php echo htmlspecialchars($row['costumer_id']) ?></td>
                            <td><?php echo htmlspecialchars($row['comment']) ?></td>
                            <td><?php echo htmlspecialchars($row['location']) ?></td>
                            <td style="text-align: center;">
                                <!-- jika ada editan, maka ID berubah -->
                                <a href="admin-edit-testdrive.php?id=<?php echo htmlspecialchars($row['testdrive_id']) ?>"><i class="fas fa-edit"></i></a> || <a href="delete.php?idt=<?php echo htmlspecialchars($row['testdrive_id']) ?>" onclick="return confirm('Are you sure?')"><i class="fas fa-trash-alt"></i></a>
                            </td>
                        </tr>
                        <?php
                                }
                                $stmt->close();
                            }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- footer -->
    <footer>
        <div class="container">
            <small>Copyright &copy; 2023 - FIXIT.</small>
        </div>
    </footer>

    <!-- ini untuk text editor dibagian deskripsi -->
    <script>
        CKEDITOR.replace('review');
    </script>
</body>
</html>
