<?php  
session_start();

// ini untuk menyambungkan ke file lain
include 'konek.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Fixit - Explore new horizons</title>
    <link rel="stylesheet" type="text/css" href="profil.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
</head>

<body>
    <!-- header -->
    <header>
        <div class="container">
            <h1><a href="dashboard.php">FIXIT</a></h1>
            <ul>
			<li><a href="admin-testdrive.php">Test Drive</a></li>
                <li><a href="admin.php">Customers</a></li>
                <li><a href="supplier.php">Supplier</a></li>
            </ul>
        </div>
    </header>

    <!-- container -->
    <div class="section">
        <div class="container">
            <h3>Add Supplier Data</h3>
            <div class="box">
                <!-- ini berkaitan dengan input upload data -->
                <form action="" method="POST" enctype="multipart/form-data">
                    <input type="text" name="supplier_id" placeholder="Supplier ID" class="input-control" required>
                    <input type="text" name="vehicle_id" placeholder="Vehicle ID" class="input-control" required>
                    <input type="text" name="name" placeholder="Supplier Name" class="input-control" required>
                    <input type="text" name="address" placeholder="Supplier Address" class="input-control" required>
                    <input type="text" name="phone_number" placeholder="Supplier Number Phone" class="input-control" required>
                    <input type="email" name="email" placeholder="Supplier Email" class="input-control" required>
                    <input type="submit" name="submit" value="Add Data" class="btn">
                </form>

                <?php 
                // jika user click tombol submit, maka..
                if (isset($_POST['submit'])) {
                    //menerima nilai dari kiriman form input-barang 
                    $supplier_id = htmlspecialchars($_POST['supplier_id']);
                    $vehicle_id = htmlspecialchars($_POST['vehicle_id']);
                    $name = htmlspecialchars($_POST['name']);
                    $address = htmlspecialchars($_POST['address']);
                    $phone_number = htmlspecialchars($_POST['phone_number']);
                    $email = htmlspecialchars($_POST['email']);

                    // Menggunakan prepared statements untuk keamanan dari SQL injection
                    $stmt = $conn->prepare("INSERT INTO supplier (supplier_id, vehicle_id, name, address, phone_number, email) VALUES (?, ?, ?, ?, ?, ?)");
                    $stmt->bind_param("ssssss", $supplier_id, $vehicle_id, $name, $address, $phone_number, $email);

                    // Mengeksekusi/menjalankan query diatas	
                    if ($stmt->execute()) {
                        echo 'Successfully Save Data';
                    } else {
                        echo '<script>alert("Failed Save Data")</script>' . htmlspecialchars($stmt->error);
                    }

                    $stmt->close();
                }
                ?>
            </div>
        </div>
    </div>

    <!-- footer -->
    <footer>
        <div class="container">
            <small>Copyright &copy; 2023 - FIXIT.</small>
        </div>
    </footer>
</body>
</html>
