<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <!-- 
    - primary meta tags
  -->
  <title>Fixit - Explore new horizons</title>
  <meta name="title" content="Fixit - Right place to own your car">
  <meta name="description" content="This is a vehicle repair html template made by codewithsadee">

  <!-- 
    - favicon
  -->
  <link rel="shortcut icon" href="favicon.svg" type="image/svg+xml">

  <!-- 
    - google font link
  -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Chakra+Petch:wght@400;600;700&family=Mulish&display=swap"
    rel="stylesheet">

  <!-- 
    - material icon font
  -->
  <link rel="stylesheet"
    href="https://fonts.googleapis.com/css2?family=Material+Symbols+Rounded:opsz,wght,FILL,GRAD@40,600,0,0" />

  <!-- 
    - custom css link
  -->
  <link rel="stylesheet" href="database.css">

  <!-- 
    - preload images
  -->
  <link rel="preload" as="image" href="hero-banner.png">
  <link rel="preload" as="image" href="hero-bg.jpg">

</head>

<body>

  <!-- 
    - #HEADER
  -->

  <header class="header">
    <div class="container">

    
      <nav class="navbar" data-navbar>
        <ul class="navbar-list">

          <li>
            <a href="#home" class="navbar-link">Home</a>
          </li>

          <li>
            <a href="#about" class="navbar-link">About</a>
          </li>

          <li>
            <a href="#service-label" class="navbar-link">Vehicals</a>
          </li>

          <li>
            <a href="buying.php" target="_blank" class="navbar-link">Member Area</a>
          </li>

          <li>
            <a href="#footer" class="navbar-link">Contact</a>
          </li>

        </ul>
      </nav>

      <a href="admin.php" class="btn btn-primary">
        <span class="span">Employee Area</span>

        <span class="material-symbols-rounded">arrow_forward</span>
      </a>

      <button class="nav-toggle-btn" aria-label="toggle menu" data-nav-toggler>
        <span class="nav-toggle-icon icon-1"></span>
        <span class="nav-toggle-icon icon-2"></span>
        <span class="nav-toggle-icon icon-3"></span>
      </button>

    </div>
  </header>





  <main>
    <article>

      <!-- 
        - #HERO
      -->

      <section class="hero has-bg-image" aria-label="home" style="background-image: url('hero-bg.jpg')">
        <div class="container">

          <div class="hero-content" id="#home">

            <p class="section-subtitle :dark">Right place to own your car</p>

            <h1 class="h1 section-title">Enjoy an easy and secure vehicles buying process</h1>

            <p class="section-text">
              We provide satisfying after-sales service to ensure customer satisfaction.
            </p>

          

          </div>

          <figure class="hero-banner" style="--width: 1228; --height: 789;">
            <img src="hero-banner.png" width="1228" height="789" alt="red motor vehicle"
              class="move-anim">
          </figure>

        </div>
      </section>





      <!-- 
        - #SERVICE
      -->

      <section class="section service has-bg-image" aria-labelledby="service-label"
        style="background-image: url('service-bg.jpg')">
        <div class="container">

          <p class="section-subtitle :light" id="service-label">Our services</p>

          <h2 class="h2 section-title">Explore our latest collection of vehicles</h2>

          <ul class="service-list">

            <li>
              <div class="service-card">

                <figure class="card-icon">
                  <img src="sedan.png" width="110" height="110" loading="lazy" alt="Engine Repair">
                </figure>

                <h3 class="h3 card-title">Car</h3>

                <p class="card-text">
                  A car is a road vehicle with four wheels that is powered by an internal combustion engine.
                </p>

              

              </div>
            </li>

            <li>
              <div class="service-card">

                <figure class="card-icon">
                  <img src="bicycle.png" width="110" height="110" loading="lazy" alt="Brake Repair">
                </figure>

                <h3 class="h3 card-title">Bicycle</h3>

                <p class="card-text">
                  A bicycle, also known as a bike, is a human-powered vehicle that has two wheels and is propelled by pedals.
                </p>

               

              </div>
            </li>

            <li>
              <div class="service-card">

                <figure class="card-icon">
                  <img src="motorbike.png" width="110" height="110" loading="lazy" alt="Tire Repair">
                </figure>

                <h3 class="h3 card-title">Motorcycle</h3>

                <p class="card-text">
                A motorcycle, also known as a motorbike or bike, is a two-wheeled vehicle powered by an internal combustion engine.
                </p>

                

              </div>
            </li>

            <li>
              <div class="service-card">

                <figure class="card-icon">
                  <img src="electric-bike.png" width="110" height="110" loading="lazy"
                    alt="Battery Repair">
                </figure>

                <h3 class="h3 card-title">Electric Motorcycle</h3>

                <p class="card-text">
                   An electric motorcycle, also known as an e-motorcycle or electric bike, is a motorcycle that is powered by an electric motor.
                </p>

              

              </div>
            </li>

            <li class="service-banner">
              <img src="motor3.png" width="646" height="380" loading="lazy" alt="Red Car"
                class="move-anim">
            </li>

            <li>
              <div class="service-card">

                <figure class="card-icon">
                  <img src="electric-car.png" width="110" height="110" loading="lazy"
                    alt="Steering Repair">
                </figure>

                <h3 class="h3 card-title">Electric Car</h3>

                <p class="card-text">
                  An electric motorcycle is a motorcycle powered by an electric motor and rechargeable battery.
                </p>

               

              </div>
            </li>

          </ul>

          <a href="buying.php" class="btn">
            <span class="span">View All Types</span>

            <span class="material-symbols-rounded">arrow_forward</span>
          </a>

        </div>
      </section>





      <!-- 
        - #ABOUT
      -->

      <section class="section about has-before" aria-labelledby="about-label">
        <div class="container">

          <figure class="hidden">
            <img src="logoo.png" width="540" height="540" loading="lazy"
              alt="vehicle repire equipments" class="w-100">
          </figure>

          <div class="about-content" id="about">

            <p class="section-subtitle :dark">About Us</p>

            <h2 class="h2 section-title">We’re Commited to Meet the quality</h2>

            <p class="section-text">
              Welcome to our website, where you can find various information about the vehicles you need. We are an online platform that provides information about vehicles, ranging from cars, motorcycles, to commercial vehicles.
            </p>

            

            <ul class="about-list">

              <li class="about-item">
                <p>
                  <strong class="display-1 strong">1</strong><a href="#">Happy Clients</a>

                </p>
              </li>

              <li class="about-item">
                <p>
                  <strong class="display-1 strong">2</strong><a href="#">Test Drive</a>
                </p>
              </li>

              <li class="about-item">
                <p>
                  <strong class="display-1 strong">3</strong><a href="#">Trusted</a>
                </p>
              </li>

              <li class="about-item">
                <p>
                  <strong class="display-1 strong">4</strong><a href="#">Easy Access</a>
                </p>
              </li>

            </ul>

          </div>

        </div>
      </section>





      


  <!-- 
    - #FOOTER
  -->

  <footer class="footer">

    <div class="footer-top section">
      <div class="container">

        <div class="footer-brand" id="footer">

         

        </div>

        <ul class="footer-list">

          <li>
            <p class="h3">Opening Hours</p>
          </li>

          <li>
            <p class="p">Monday – Friday</p>

            <span class="span">09.00 – 14.45</span>
          </li>


          <li>
            <p class="p">Saturday – Sunday</p>

            <span class="span">12.00 – 17.00</span>
          </li>

        </ul>

        <ul class="footer-list">

          <li>
            <p class="h3">Contact Info</p>
          </li>

          <li>
            <a href="tel:+01234567890" class="footer-link">
              <span class="material-symbols-rounded">call</span>

              <span class="span">089660294320</span>
            </a>
          </li>

          <li>
            <a href="mailto:info@autofix.com" class="footer-link">
              <span class="material-symbols-rounded">instagram</span>

              <span class="span">@fixit</span>
            </a>
          </li>

          <li>
            <address class="footer-link address">
              <span class="material-symbols-rounded">location_on</span>

              <span class="span">Jababeka Education Park, Jl. Ki Hajar Dewantara, RT.2/RW.4, Mekarmukti, Kec. Cikarang Utara, Kabupaten Bekasi, Jawa Barat 17530</span>
            </address>
          </li>

        </ul>

      </div>

      <img src="footer-shape-3.png" width="637" height="173" loading="lazy" alt="Shape"
        class="shape shape-3 move-anim">

    </div>

    <div class="footer-bottom">
      <div class="container">

        <p class="copyright">Copyright 2022, All Rights Reserved.</p>

        <img src="footer-shape-2.png" width="778" height="335" loading="lazy" alt="Shape"
          class="shape shape-2">

        <img src="footer-shape-1.png" width="805" height="652" loading="lazy" alt="Red Car"
          class="shape shape-1 move-anim">

      </div>
    </div>

  </footer>





  <!-- 
    - custom js link
  -->
  <script src="script.js"></script>

</body>

</html>