<?php
// Start the session
session_start();
include 'konek.php';

// Redirect to login page if not logged in
// if (!isset($_SESSION['status_login']) || $_SESSION['status_login'] !== true) {
//     echo '<script>window.location="loginn.php"</script>';
//     exit;
// }

// Query to get best sales products
$query = "SELECT 
        c.model_name, 
        c.year AS car_year, 
        s.price AS price, 
        c.image_link AS image_link, 
        COUNT(*) AS total_sales,
        GROUP_CONCAT(DISTINCT CONCAT(f.feature_name, ': ', f.feature_value) SEPARATOR ', ') AS features
    FROM cars c
    JOIN sales s ON c.car_id = s.car_id
    LEFT JOIN car_features f ON c.car_id = f.car_id
    GROUP BY c.car_id
    ORDER BY total_sales DESC
    LIMIT 3";

$result = mysqli_query($conn, $query);
if (!$result) {
    die('Query failed: ' . mysqli_error($conn));
}


$cars = mysqli_fetch_all($result, MYSQLI_ASSOC);

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Fixit - Explore new horizons</title>

  <link rel="stylesheet" href="buying.css">

  <!-- 
    - google font link
  -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600&family=Open+Sans&display=swap" rel="stylesheet">




  <script src="color-modes.js"></script>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="Mark Otto, Jacob Thornton, and Bootstrap contributors">
    <meta name="generator" content="Hugo 0.122.0">
    <title>Chart · TOP SALES VEHICLES</title>

    <link rel="canonical" href="https://getbootstrap.com/docs/5.3/examples/dashboard/">

    

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@docsearch/css@3">

<link href="bootstrap.min.css" rel="stylesheet">

    <style>
      .bd-placeholder-img {
        font-size: 1.125rem;
        text-anchor: middle;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
      }

      @media (min-width: 768px) {
        .bd-placeholder-img-lg {
          font-size: 3.5rem;
        }
      }

      .b-example-divider {
        width: 100%;
        height: 3rem;
        background-color: rgba(0, 0, 0, .1);
        border: solid rgba(0, 0, 0, .15);
        border-width: 1px 0;
        box-shadow: inset 0 .5em 1.5em rgba(0, 0, 0, .1), inset 0 .125em .5em rgba(0, 0, 0, .15);
      }

      .b-example-vr {
        flex-shrink: 0;
        width: 1.5rem;
        height: 100vh;
      }

      .bi {
        vertical-align: -.125em;
        fill: currentColor;
      }

      .nav-scroller {
        position: relative;
        z-index: 2;
        height: 2.75rem;
        overflow-y: hidden;
      }

      .nav-scroller .nav {
        display: flex;
        flex-wrap: nowrap;
        padding-bottom: 1rem;
        margin-top: -1px;
        overflow-x: auto;
        text-align: center;
        white-space: nowrap;
        -webkit-overflow-scrolling: touch;
      }

      .btn-bd-primary {
        --bd-violet-bg: #712cf9;
        --bd-violet-rgb: 112.520718, 44.062154, 249.437846;

        --bs-btn-font-weight: 600;
        --bs-btn-color: var(--bs-white);
        --bs-btn-bg: var(--bd-violet-bg);
        --bs-btn-border-color: var(--bd-violet-bg);
        --bs-btn-hover-color: var(--bs-white);
        --bs-btn-hover-bg: #6528e0;
        --bs-btn-hover-border-color: #6528e0;
        --bs-btn-focus-shadow-rgb: var(--bd-violet-rgb);
        --bs-btn-active-color: var(--bs-btn-hover-color);
        --bs-btn-active-bg: #5a23c8;
        --bs-btn-active-border-color: #5a23c8;
      }

      .bd-mode-toggle {
        z-index: 1500;
      }

      .bd-mode-toggle .dropdown-menu .active .bi {
        display: block !important;
      }
    </style>

    
    <!-- Custom styles for this template -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.min.css" rel="stylesheet">
    <!-- Custom styles for this template -->
    <link href="dashboard.css" rel="stylesheet">
</head>

<body>

  <!-- 
    - #HEADER
  -->

  <header class="header" style="background-color: #1a2642;" data-header>
    <div class="container">

      <div class="overlay" data-overlay></div>

      <!-- <a href="#" class="logo">
        <img src="./assets/images/logo.svg" alt="Ridex logo">
      </a> -->

      <nav class="navbar" data-navbar>
        <ul class="navbar-list">

          <!-- <li>
            <a href="#home" class="navbar-link" data-nav-link>Home</a>
          </li> -->

          <li>
            <a href="database.php" class="navbar-link" style="color: white;" data-nav-link>Home</a>
          </li>

          <li>
            <a href="#footer" class="navbar-link" style="color: white;" data-nav-link>Contact</a>
          </li>

        </ul>
      </nav>

      <div class="header-actions">

        <!-- <div class="header-contact">
          <a href="tel:88002345678" class="contact-link">8 800 234 56 78</a>

          <span class="contact-time">Mon - Sat: 9:00 am - 6:00 pm</span>
        </div> -->

        <a href="#featured-car" class="btn" aria-labelledby="aria-label-txt">
          <ion-icon name="car-outline"></ion-icon>

          <span id="aria-label-txt" style="color: white;">Let's Explore </span>
        </a>

        <a href="profil.php" class="btn user-btn" aria-label="Profile">
          <span id="aria-label-txt" style="color: white;">Profile</span>
        </a>

        <a href="customer-testdrive.php" class="btn user-btn" aria-label="Profile">
          <span id="aria-label-txt" style="color: white;">Tell Your Experience!</span>
        </a>

        <!-- <button class="nav-toggle-btn" data-nav-toggle-btn aria-label="Toggle Menu">
          <span class="one"></span>
          <span class="two"></span>
          <span class="three"></span>
        </button> -->

      </div>

    </div>
  </header>





  <main>
    <article>

      <!-- 
        - #HERO
      -->

      <section class="section hero" id="home" aria-labelledby="buying-label" style="background-image: url('service-bg.jpg')">
        <div class="container">

          <div class="hero-content">
            <strong>
              <h1 class="h1 hero-text">Enjoy an easy and secure vehicles buying process</h1>
            </strong>

            <p class="hero-text">
              Right place to own your car
            </p>
          </div>

          <div class="hero-banner"></div>


        </div>
      </section>








      <section class="section featured-car" id="featured-car" style="background-image: url('service-bg.jpg')">
        <div class="container">
    <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
      <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
        <h1 class="h2">Sales of The Year</h1>
      </div>
      <br> <br>

      <canvas class="my-4 w-100" id="myChart" width="900" height="380"></canvas>
     
    </main>
  </div>
</div>
<script src="bootstrap.bundle.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.3.2/dist/chart.umd.js" integrity="sha384-eI7PSr3L1XLISH8JdDII5YN/njoSsxfbrkCTnJrzXt+ENP5MOVBxD+l6sEG4zoLp" crossorigin="anonymous"></script><script src="dashboard.js"></script>
     </div>
      </section>























      <!-- Top Sales Section -->
      <section class="section featured-car" id="featured-car" style="background-image: url('service-bg.jpg')">
        <div class="container">
          <div class="title-wrapper">
            <h2 class="h2 section-title">Best Sales</h2>
          </div>
          <ul class="featured-car-list">
            <?php foreach ($cars as $car) : ?>
              <li>
                <div class="featured-car-card">
                  <figure class="card-banner">
                    <img src="<?php echo htmlspecialchars($car['image_link']); ?>" alt="<?php echo htmlspecialchars($car['model_name']); ?>" loading="lazy" width="440" height="300" class="w-100">
                  </figure>
                  <div class="card-content">
                    <div class="card-title-wrapper">
                      <h3 class="h3 card-title">
                        <a href="#"><?php echo htmlspecialchars($car['model_name']); ?></a>
                      </h3>
                      <data class="year" value="<?php echo htmlspecialchars($car['car_year']); ?>"><?php echo htmlspecialchars($car['car_year']); ?></data>
                    </div>
                    <ul class="card-list">
                      <?php echo generateFeatureList($car['features']); ?>
                    </ul>
                    <div class="card-price-wrapper">
                      <p class="card-price">
                        <strong>Rp <?php echo number_format($car['price'], 0, ',', '.'); ?>,-</strong>
                      </p>
                    </div>
                  </div>
                </div>
              </li>
            <?php endforeach; ?>
          </ul>
        </div>
      </section>

      <?php
      function generateFeatureList($features)
      {
        $featuresArray = explode(', ', $features);
        $html = '';
        foreach ($featuresArray as $feature) {
          list($name, $value) = explode(': ', $feature);
          $html .= '<li class="card-list-item"><ion-icon name="checkmark-outline"></ion-icon><span class="card-item-text">' . htmlspecialchars($name) . ': ' . htmlspecialchars($value) . '</span></li>';
        }
        return $html;
      }
      ?>

      <!-- 
        - #FEATURED CAR
      -->


      <section class="section featured-car" id="featured-car" style="background-image: url('service-bg.jpg')">
        <div class="container">

          <div class="title-wrapper">
            <h2 class="h2 section-title">News Product</h2>

            <a href="car.php" class="featured-car-link">
              <span>View more cars</span>

              <ion-icon name="arrow-forward-outline"></ion-icon>
            </a>
          </div>

          <ul class="featured-car-list">

            <li>
              <div class="featured-car-card">

                <figure class="card-banner">
                  <img src="Acura_MDX.png" alt="Toyota RAV4 2021" loading="lazy" width="440" height="300" class="w-100">
                </figure>

                <div class="card-content">

                  <div class="card-title-wrapper">
                    <h3 class="h3 card-title">
                      <a href="#">Acura MDX</a>
                    </h3>

                    <data class="year" value="2022">2022</data>
                  </div>

                  <ul class="card-list">

                    <li class="card-list-item">
                      <ion-icon name="people-outline"></ion-icon>

                      <span class="card-item-text">4 People</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="flash-outline"></ion-icon>

                      <span class="card-item-text">Hybrid</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="speedometer-outline"></ion-icon>

                      <span class="card-item-text">7,98km / 1-litre</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="hardware-chip-outline"></ion-icon>

                      <span class="card-item-text">Automatic</span>
                    </li>

                  </ul>

                  <div class="card-price-wrapper">

                    <p class="card-price">
                      <strong>Rp 926.250.000,-</strong>
                    </p>

                    <!-- <button class="btn fav-btn" aria-label="Add to favourite list">
                      <ion-icon name="heart-outline"></ion-icon>
                    </button>
 -->
                    <!-- <button class="btn">Buy now</button> -->

                  </div>

                </div>

              </div>
            </li>






            <li>
              <div class="featured-car-card">

                <figure class="card-banner">
                  <img src="Ducati_Panigale_V4.png" alt="Volkswagen T-Cross 2020" loading="lazy" width="440" height="300" class="w-100">
                </figure>

                <div class="card-content">

                  <div class="card-title-wrapper">
                    <h3 class="h3 card-title">
                      <a href="#">Ducati Panigale V4</a>
                    </h3>

                    <data class="year" value="2021">2021</data>
                  </div>

                  <ul class="card-list">

                    <!-- <li class="card-list-item">
                      <ion-icon name="people-outline"></ion-icon>

                      <span class="card-item-text">2 People</span>
                    </li> -->

                    <li class="card-list-item">
                      <ion-icon name="flash-outline"></ion-icon>

                      <span class="card-item-text">Gasoline</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="speedometer-outline"></ion-icon>

                      <span class="card-item-text">15km / 1-litre</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="hardware-chip-outline"></ion-icon>

                      <span class="card-item-text">Manual</span>
                    </li>

                  </ul>

                  <div class="card-price-wrapper">

                    <p class="card-price">
                      <strong>RP 1.200.080.000,-</strong>
                    </p>

                    <!-- <button class="btn fav-btn" aria-label="Add to favourite list">
                      <ion-icon name="heart-outline"></ion-icon>
                    </button>

                    <button class="btn">Buy now</button> -->

                  </div>

                </div>

              </div>
            </li>

            <li>
              <div class="featured-car-card">

                <figure class="card-banner">
                  <img src="Bentley_Continental_GT.png" alt="BMW 4 Series GTI 2021" loading="lazy" width="440" height="300" class="w-100">
                </figure>

                <div class="card-content">

                  <div class="card-title-wrapper">
                    <h3 class="h3 card-title">
                      <a href="#">Bentley Continental GT</a>
                    </h3>

                    <data class="year" value="2022">2022</data>
                  </div>

                  <ul class="card-list">

                    <li class="card-list-item">
                      <ion-icon name="people-outline"></ion-icon>

                      <span class="card-item-text">2 People</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="flash-outline"></ion-icon>

                      <span class="card-item-text">Gasoline</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="speedometer-outline"></ion-icon>

                      <span class="card-item-text">9,26km / 1-litre</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="hardware-chip-outline"></ion-icon>

                      <span class="card-item-text">Automatic</span>
                    </li>

                  </ul>

                  <div class="card-price-wrapper">

                    <p class="card-price">
                      <strong>RP 3,052,000,000,-</strong>
                    </p>

                    <!-- <button class="btn fav-btn" aria-label="Add to favourite list">
                      <ion-icon name="heart-outline"></ion-icon>
                    </button>
 -->
                    <!-- <button class="btn">Buy now</button> -->

                  </div>

                </div>

              </div>
            </li>


            <li>
              <div class="featured-car-card">

                <figure class="card-banner">
                  <img src="Yamaha_Wabash.png" alt="Toyota RAV4 2021" loading="lazy" width="440" height="300" class="w-100">
                </figure>

                <div class="card-content">

                  <div class="card-title-wrapper">
                    <h3 class="h3 card-title">
                      <a href="#">Yamaha Wabash</a>
                    </h3>

                    <data class="year" value="2021">2021</data>
                  </div>

                  <ul class="card-list">


                    <li class="card-list-item">
                      <ion-icon name="speedometer-outline"></ion-icon>

                      <span class="card-item-text">25,6km / 1-kWh</span>
                    </li>

                  </ul>

                  <div class="card-price-wrapper">

                    <p class="card-price">
                      <strong>Rp 50.000.000,-</strong>
                    </p>

                    <!-- <button class="btn fav-btn" aria-label="Add to favourite list">
                      <ion-icon name="heart-outline"></ion-icon>
                    </button>

                    <button class="btn">Buy now</button> -->

                  </div>

                </div>

              </div>
            </li>



            <li>
              <div class="featured-car-card">

                <figure class="card-banner">
                  <img src="Ford_Mustang_Mach-E.png" alt="BMW 3 Series 2019" loading="lazy" width="440" height="300" class="w-100">
                </figure>

                <div class="card-content">

                  <div class="card-title-wrapper">
                    <h3 class="h3 card-title">
                      <a href="#">Ford Mustang Mach-E</a>
                    </h3>

                    <data class="year" value="2021">2021</data>
                  </div>

                  <ul class="card-list">

                    <li class="card-list-item">
                      <ion-icon name="people-outline"></ion-icon>

                      <span class="card-item-text">4 People</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="flash-outline"></ion-icon>

                      <span class="card-item-text">Electric</span>
                    </li>

                    <!-- <li class="card-list-item">
                      <ion-icon name="speedometer-outline"></ion-icon>

                      <span class="card-item-text">9,3 km / 1-litre</span>
                    </li> -->

                    <li class="card-list-item">
                      <ion-icon name="hardware-chip-outline"></ion-icon>

                      <span class="card-item-text">Automatic</span>
                    </li>

                  </ul>

                  <div class="card-price-wrapper">

                    <p class="card-price">
                      <strong>RP 600.000.000,-</strong>
                    </p>

                    <!-- <button class="btn fav-btn" aria-label="Add to favourite list">
                      <ion-icon name="heart-outline"></ion-icon>
                    </button>

                    <button class="btn">Buy now</button> -->

                  </div>

                </div>

              </div>
            </li>
            </li>

            <li>
              <div class="featured-car-card">

                <figure class="card-banner">
                  <img src="Zero_SRF.png" alt="BMW 3 Series 2019" loading="lazy" width="440" height="300" class="w-100">
                </figure>

                <div class="card-content">

                  <div class="card-title-wrapper">
                    <h3 class="h3 card-title">
                      <a href="#">Zero SRF</a>
                    </h3>

                    <data class="year" value="2022">2022</data>
                  </div>

                  <ul class="card-list">

                    <!--   <li class="card-list-item">
                      <ion-icon name="people-outline"></ion-icon>

                      <span class="card-item-text">4 People</span>
                    </li> -->

                    <li class="card-list-item">
                      <ion-icon name="flash-outline"></ion-icon>

                      <span class="card-item-text">Electric</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="speedometer-outline"></ion-icon>

                      <span class="card-item-text"> - / 1-litre</span>
                    </li>

                    <li class="card-list-item">
                      <ion-icon name="hardware-chip-outline"></ion-icon>

                      <span class="card-item-text">Automatic</span>
                    </li>

                  </ul>

                  <div class="card-price-wrapper">

                    <p class="card-price">
                      <strong>RP 400.000.000,-</strong>
                    </p>

                    <!-- <button class="btn fav-btn" aria-label="Add to favourite list">
                      <ion-icon name="heart-outline"></ion-icon>
                    </button>

                    <button class="btn">Buy now</button>
 -->
                  </div>

                </div>

              </div>
            </li>
          </ul>

        </div>
      </section>








      <!-- 
        - #BLOG
      -->

      <section class="section blog" id="blog" style="background-image: url('service-bg.jpg')">
        <div class="container">

          <h2 class="h2 section-title">Our collections</h2>

          <ul class="blog-list has-scrollbar">

            <li>
              <div class="blog-card">

                <figure class="card-banner">

                  <a href="electric-car.php">
                    <img src="electric-car.jpg" alt="Opening of new offices of the company" loading="lazy" class="w-100">
                  </a>

                  <a href="electric-car.php" class="btn card-badge">See more</a>

                </figure>

                <div class="card-content">

                  <h3 class="h3 card-title">
                    <p>Electric Car</p>
                  </h3>

                  <div class="card-meta">

                    <div class="publish-date">
                      <ion-icon name="time-outline"></ion-icon>

                      <time datetime="2022-01-14">April 06, 2023</time>
                    </div>

                    <!-- <div class="comments">
                      <ion-icon name="chatbubble-ellipses-outline"></ion-icon> -->

                    <!-- <data value="114">114</data> -->
                    <!-- </div> -->

                  </div>

                </div>

              </div>
            </li>

            <li>
              <div class="blog-card">

                <figure class="card-banner">

                  <a href="electric-motorcycle.php">
                    <img src="electric-motorcycle.jpg" alt="What cars are most vulnerable" loading="lazy" class="w-100">
                  </a>

                  <a href="electric-motorcycle.php" class="btn card-badge">See more</a>

                </figure>

                <div class="card-content">

                  <h3 class="h3 card-title">
                    <p>Electric Motorcycle</p>
                  </h3>

                  <div class="card-meta">

                    <div class="publish-date">
                      <ion-icon name="time-outline"></ion-icon>

                      <time datetime="2022-01-14">April 19, 2023</time>
                    </div>

                    <!-- div class="comments">
                      <ion-icon name="chatbubble-ellipses-outline"></ion-icon>

                      <data value="114">114</data>
                    </div> -->

                  </div>

                </div>

              </div>
            </li>

            <li>
              <div class="blog-card">

                <figure class="card-banner">

                  <a href="motorcycle.php">
                    <img src="motorbike.jpg" alt="Statistics showed which average age" loading="lazy" class="w-100">
                  </a>

                  <a href="motorcycle.php"  class="btn card-badge">See more</a>

                </figure>

                <div class="card-content">

                  <h3 class="h3 card-title">
                    <p>Motorcycle</p>
                  </h3>

                  <div class="card-meta">

                    <div class="publish-date">
                      <ion-icon name="time-outline"></ion-icon>

                      <time datetime="2022-01-14">March 5, 2023</time>
                    </div>

                    <!-- <div class="comments">
                      <ion-icon name="chatbubble-ellipses-outline"></ion-icon>

                      <data value="114">114</data>
                    </div> -->

                  </div>

                </div>

              </div>
            </li>

            <li>
              <div class="blog-card">

                <figure class="card-banner">

                  <a href="car.php">
                    <img src="hero-banner.jpg" alt="What´s required when renting a car?" loading="lazy" class="w-100">
                  </a>

                  <a href="car.php" class="btn card-badge">See more</a>

                </figure>

                <div class="card-content">

                  <h3 class="h3 card-title">
                    <p>Car</p>
                  </h3>

                  <div class="card-meta">

                    <div class="publish-date">
                      <ion-icon name="time-outline"></ion-icon>

                      <time datetime="2022-01-14">January 03, 2023</time>
                    </div>

                    <!-- <div class="comments">
                      <ion-icon name="chatbubble-ellipses-outline"></ion-icon>

                      <data value="114">114</data>
                    </div> -->

                  </div>

                </div>

              </div>
            </li>

            <li>
              <div class="blog-card">

                <figure class="card-banner">

                  <a href="electric-bike.php">
                    <img src="electric-bike.jpg" alt="New rules for handling our cars" loading="lazy" class="w-100">
                  </a>

                  <a href="electric-bike.php" class="btn card-badge">See more</a>

                </figure>

                <div class="card-content">

                  <h3 class="h3 card-title">
                    <p>Electric Bicycle</p>
                  </h3>

                  <div class="card-meta">

                    <div class="publish-date">
                      <ion-icon name="time-outline"></ion-icon>

                      <time datetime="2022-01-14">March 17, 2022</time>
                    </div>

                    <!-- <div class="comments">
                      <ion-icon name="chatbubble-ellipses-outline"></ion-icon>

                      <data value="114">114</data>
                    </div> -->

                  </div>

                </div>

              </div>
            </li>

          </ul>

        </div>
      </section>

    </article>
  </main>





  <!-- 
    - #FOOTER
  -->

  <footer class="footer" id="footer" style="background-image: url('service-bg.jpg')">

    <div class="footer-top section" style="background-color: #1a2642;">
      <div class="container">


        <ul class="footer-list">

          <li>
            <p class="h1">Opening Hours</p>
          </li>

          <li>
            <p class="p">Monday – Friday</p>

            <span class="h3" style="background-color: #1a2642;">09.00 – 14.45</span>
          </li>


          <li>
            <p class="p">Saturday – Sunday</p>

            <span class="h3">12.00 – 17.00</span>
          </li>

        </ul>

        <ul class="footer-list">

          <li>
            <p class="h1">Contact Info</p>
          </li>

          <li>
            <span class="h3">call:</span>

            <span class="p">089660294320</span>
          </li>

          <li>
            <span class="h3">instagram:</span>

            <span class="p">@fixit</span>
            </a>
          </li>

          <li>

            <span class="h3">location on:</span>

            <span class="p">Jababeka Education Park, Jl. Ki Hajar Dewantara, RT.2/RW.4, Mekarmukti, Kec. Cikarang Utara, Kabupaten Bekasi, Jawa Barat 17530</span>

          </li>

        </ul>

      </div>

      <img src="footer-shape-3.png" width="637" height="173" loading="lazy" alt="Shape" class="shape shape-3 move-anim">

    </div>

    <div class="footer-bottom">
      <div class="container">


        <small style="color: black;">Copyright & copy; 2023 - FIXIT.</small>


        <img src="footer-shape-2.png" width="778" height="335" loading="lazy" alt="Shape" class="shape shape-2">

        <img src="footer-shape-1.png" width="805" height="652" loading="lazy" alt="Red Car" class="shape shape-1 move-anim">

      </div>
    </div>

  </footer>





  <!-- 
    - custom js link
  -->
  <script src="script.js"></script>

  <!-- 
    - ionicon link
  -->
  <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
  <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>

</body>

</html>