<?php
session_start();
include 'konek.php';

// Pastikan koneksi ke database berhasil
if (!$conn) {
    die('Connection failed: ' . mysqli_connect_error());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Registration</title>
    <link rel="stylesheet" type="text/css" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
</head>
<body id="bg-login">
    <div class="box-login">
        <h3>Admin Registration</h3>
        <form action="" method="POST">
            <input type="text" name="employee_id" placeholder="Employee ID" class="input-control" required>
            <input type="text" name="name" placeholder="Employee Name" class="input-control" required>
            <input type="text" name="address" placeholder="Address" class="input-control" required>
            <input type="text" name="phone_number" placeholder="Phone Number" class="input-control" required>
            <input type="submit" name="submit" value="Register" class="btn">
        </form>

        <?php
        if (isset($_POST['submit'])) {
            // Menerima nilai dari kiriman form input
            $employee_id = htmlspecialchars($_POST['employee_id']);
            $name = htmlspecialchars($_POST['name']);
            $address = htmlspecialchars($_POST['address']);
            $phone_number = htmlspecialchars($_POST['phone_number']);

            // Mengeksekusi query untuk menyimpan data
            $query = "INSERT INTO employee (employee_id, name, address, phone_number) VALUES (?, ?, ?, ?)";
            $stmt = mysqli_prepare($conn, $query);

            if ($stmt) {
                mysqli_stmt_bind_param($stmt, 'ssss', $employee_id, $name, $address, $phone_number);
                $execute = mysqli_stmt_execute($stmt);

                // Kondisi apakah berhasil atau tidak
                if ($execute) {
                    echo '<script>alert("Successfully Registered")</script>';
                    echo '<script>window.location="admin.php"</script>';
                } else {
                    echo '<script>alert("Failed to Register")</script>' . mysqli_error($conn);
                }

                mysqli_stmt_close($stmt);
            } else {
                echo '<script>alert("Failed to prepare statement")</script>' . mysqli_error($conn);
            }
        }
        ?>

        <div class="Reg">
            <p>Already have an account?</p>
            <p class="a"><a href="admin-login.php">Login</a></p>
        </div>
    </div>
</body>
</html>
