<?php  
session_start();
// Menyambungkan ke file lain
include 'konek.php';

// // Memastikan pengguna telah login
// if (!isset($_SESSION['status_login']) || $_SESSION['status_login'] !== true) {
//     echo '<script>window.location="login.php"</script>';
//     exit;
// }

// Mengambil nilai dari parameter id
$id = $_GET['id'] ?? '';
if ($id === '') {
    echo '<script>alert("ID tidak ditemukan")</script>';
    echo '<script>window.location="admin-testdrive.php"</script>';
    exit;
}

// Query SQL untuk menampilkan data berdasarkan id
$stmt = $conn->prepare("SELECT * FROM test_drive WHERE testdrive_id = ?");
$stmt->bind_param('s', $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
if (!$data) {
    echo '<script>alert("Data tidak ditemukan")</script>';
    echo '<script>window.location="admin-testdrive.php"</script>';
    exit;
}
$stmt->close();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Fixit - Explore new horizons</title>
    <link rel="stylesheet" type="text/css" href="profil.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
</head>

<body>
    <!-- header -->
    <header>
        <div class="container">
            <h1><a href="database.php">FIXIT</a></h1>
            <ul>
			<li><a href="admin-testdrive.php">Test Drive</a></li>
                <li><a href="admin.php">Customers</a></li>
                <li><a href="supplier.php">Supplier</a></li>
            </ul>
        </div>
    </header>

    <!-- container -->
    <div class="section">
        <div class="container">
            <h3>Edit Customer Test Drive Data</h3>
            <div class="box">
                <!-- Form untuk mengedit data -->
                <form action="" method="POST" enctype="multipart/form-data">
                    <input type="text" name="testdrive_id" placeholder="Test Drive ID" class="input-control" value="<?php echo htmlspecialchars($data['testdrive_id']); ?>" required>
                    <input type="text" name="vehicle_id" placeholder="Vehicle ID" class="input-control" value="<?php echo htmlspecialchars($data['vehicle_id']); ?>" required>
                    <input type="text" name="costumer_id" placeholder="Customer ID" class="input-control" value="<?php echo htmlspecialchars($data['costumer_id']); ?>" required>
                    <input type="text" name="comment" placeholder="Write Your Review" class="input-control" value="<?php echo htmlspecialchars($data['comment']); ?>" required>
                    <input type="text" name="location" placeholder="Location" class="input-control" value="<?php echo htmlspecialchars($data['location']); ?>" required>
                    <input type="submit" name="submit" value="Edit Data" class="btn">
                </form>

                <?php
                if (isset($_POST['submit'])) {
                    $stmt = $conn->prepare("UPDATE test_drive SET
                        testdrive_id = ?, vehicle_id = ?, costumer_id = ?, comment = ?, location = ?
                        WHERE testdrive_id = ?");
                    $stmt->bind_param(
                        'ssssss',
                        $_POST['testdrive_id'],
                        $_POST['vehicle_id'],
                        $_POST['costumer_id'],
                        $_POST['comment'],
                        $_POST['location'],
                        $id
                    );
                    if ($stmt->execute()) {
                        echo '<script>alert("Successfully Edit data")</script>';
                        echo '<script>window.location="admin-edit-testdrive.php"</script>';
                    } else {
                        echo '<script>alert("Failed to add data")</script>';
                    }
                    $stmt->close();
                }
                ?>

            </div>
        </div>
    </div>

    <!-- footer -->
    <footer>
        <div class="container">
            <small>Copyright &copy; 2023 - FIXIT.</small>
        </div>
    </footer>
</body>
</html>
