<?php  
session_start();
// ini untuk menyambungkan ke file lain
include 'konek.php';

//untuk mengambil value dari paramater id=
$id = $_GET['id'] ?? null;

if ($id) {
    //query sql untuk menampilkan data berdasarkan id
    $stmt = $conn->prepare("SELECT * FROM pelanggan WHERE costumer_id = ?");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    //menampilkan data dari query database berbentuk array an ditampilkan di form
    $t = $result->fetch_assoc();
}

?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Fixit - Explore new horizons</title>
    <link rel="stylesheet" type="text/css" href="profil.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
</head>

<body>
    <!-- header -->
    <header>
        <div class="container">
            <h1><a href="database.php">FIXIT</a></h1>
            <ul>
			<li><a href="admin-testdrive.php">Test Drive</a></li>
                <li><a href="admin.php">Customers</a></li>
                <li><a href="supplier.php">Supplier</a></li>
            </ul>
        </div>
    </header>

    <!-- container -->
    <div class="section">
        <div class="container">
            <h3>Edit Customer Data</h3>
            <div class="box">
                <!-- ini berkaitan dengan input upload data -->
                <form action="" method="POST" enctype="multipart/form-data">
                    <input type="text" name="costumer_name" placeholder="Customer Name" class="input-control" value="<?php echo htmlspecialchars($t['costumer_name'] ?? '') ?>" required>
                    <input type="text" name="costumer_num" placeholder="Customer Number Phone" class="input-control" value="<?php echo htmlspecialchars($t['costumer_num'] ?? '') ?>" required>
                    <input type="text" name="costumer_email" placeholder="Customer Email" class="input-control" value="<?php echo htmlspecialchars($t['costumer_email'] ?? '') ?>" required>
                    <input type="text" name="costumer_address" placeholder="Customer Address" class="input-control" value="<?php echo htmlspecialchars($t['costumer_address'] ?? '') ?>" required>
                    <input type="text" name="employee_id" placeholder="Employee ID" class="input-control" value="<?php echo htmlspecialchars($t['employee_id'] ?? '') ?>" required>
                    <input type="submit" name="submit" value="Edit Data" class="btn">
                </form>

                <?php
                if (isset($_POST['submit'])) {
                    $stmt = $conn->prepare("UPDATE pelanggan SET costumer_name = ?, costumer_num = ?, costumer_email = ?, costumer_address = ?, employee_id = ? WHERE costumer_id = ?");
                    $stmt->bind_param(
                        "ssssss",
                        $_POST['costumer_name'],
                        $_POST['costumer_num'],
                        $_POST['costumer_email'],
                        $_POST['costumer_address'],
                        $_POST['employee_id'],
                        $id
                    );

                    if ($stmt->execute()) {
                        echo '<script>alert("Successfully Edit data")</script>';
                        echo '<script>window.location=admin.php</script>';
                    } else {
                        echo '<script>alert("Failed to add data")</script>';
                    }
                }
                ?>
            </div>
        </div>
    </div>

    <!-- footer -->
    <footer>
        <div class="container">
            <small>Copyright &copy; 2023 - FIXIT.</small>
        </div>
    </footer>
</body>
</html>
