<?php  
session_start();
// ini untuk menyambungkan ke file lain
include 'konek.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Fixit - Explore new horizons</title>
    <link rel="stylesheet" type="text/css" href="profil.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
</head>

<body>
    <!-- header -->
    <header>
        <div class="container">
            <h1><a href="database.php">FIXIT</a></h1>
            <ul>
			<li><a href="admin-testdrive.php">Test Drive</a></li>
                <li><a href="admin.php">Customers</a></li>
                <li><a href="supplier.php">Supplier</a></li>
            </ul>
        </div>
    </header>

    <!-- container -->
    <div class="section">
        <div class="container">
            <h3>Add Data Test Drive</h3>
            <div class="box">
                <!-- ini berkaitan dengan input upload data -->
                <form action="" method="POST" enctype="multipart/form-data">
                    <input type="text" name="testdrive_id" placeholder="Test Drive ID" class="input-control" required>
                    <input type="text" name="vehicle_id" placeholder="Vehicle ID" class="input-control" required>
                    <input type="text" name="costumer_id" placeholder="Customer ID" class="input-control" required>
                    <input type="text" name="costumer_name" placeholder="Customer Name" class="input-control" required>
                    <input type="email" name="costumer_email" placeholder="Customer Email" class="input-control" required>
                    <input type="text" name="comment" placeholder="Your Result" class="input-control" required>
                    <input type="text" name="location" placeholder="Location Test" class="input-control" required>
                    <input type="submit" name="submit" value="Add Data" class="btn">
                </form>

                <?php
                if (isset($_POST['submit'])) {
                    //menerima nilai dari kiriman form input-barang 
					$testdrive_id	=$_POST['testdrive_id'];
					$vehicle_id		=$_POST['vehicle_id'];
					$costumer_id	=$_POST['costumer_id'];
					$comment 		=$_POST['comment'];
					$location		=$_POST['location'];

                    // Menggunakan prepared statements untuk keamanan dari SQL injection
                    $stmt = $conn->prepare("INSERT INTO test_drive (testdrive_id, vehicle_id, costumer_id, comment, location) VALUES (?, ?, ?, ?, ?)");
                    $stmt->bind_param("sssss", $testdrive_id, $vehicle_id, $costumer_id, $comment, $location);

                    if ($stmt->execute()) {
                        echo 'Successfully Save Data';
                    } else {
                        echo '<script>alert("Failed Save Data")</script>' . htmlspecialchars($stmt->error);
                    }
                    
                    $stmt->close();
                }
                ?>
            </div>
        </div>
    </div>

    <!-- footer -->
    <footer>
        <div class="container">
            <small>Copyright &copy; 2023 - FIXIT.</small>
        </div>
    </footer>
</body>
</html>
