<?php  
    session_start();
    // Ini untuk menyambungkan ke file lain
    include 'konek.php';
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Fixit - Explore new horizons</title>
    <link rel="stylesheet" type="text/css" href="profil.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins&display=swap" rel="stylesheet">
    <script src="https://cdn.ckeditor.com/4.21.0/standard/ckeditor.js"></script>
</head>
<body>
    <!-- header -->
    <header>
        <div class="container">
            <h1><a href="dashboard.php">FIXIT</a></h1>
            <ul>
                <li><a href="admin-testdrive.php">Test Drive</a></li>
                <li><a href="admin.php">Customers</a></li>
                <li><a href="supplier.php">Supplier</a></li>
            </ul>
        </div>
    </header>

    <!-- container -->
    <div class="section">
        <div class="container">
            <h3>Add Customer Data</h3>
            <div class="box">
                <!-- Ini berkaitan dengan input upload data -->
                <form action="" method="POST" enctype="multipart/form-data">
                    <input type="text" name="costumer_id" placeholder="Customer ID" class="input-control" required>
                    <input type="text" name="costumer_name" placeholder="Customer Name" class="input-control" required>
                    <input type="text" name="costumer_num" placeholder="Customer Number Phone" class="input-control" required>
                    <input type="email" name="costumer_email" placeholder="Customer Email" class="input-control" required>
                    <input type="text" name="costumer_address" placeholder="Customer Address" class="input-control" required>
                    <input type="text" name="employee_id" placeholder="Employee ID" class="input-control" required>
                    <input type="submit" name="submit" value="Add Data" class="btn">
                </form>

                <?php 
                    // Jika user klik tombol submit, maka..
                    if (isset($_POST['submit'])) {
                        // Menerima nilai dari kiriman form input-barang dengan sanitasi
                        $costumer_id = filter_input(INPUT_POST, 'costumer_id', FILTER_SANITIZE_STRING);
                        $costumer_name = filter_input(INPUT_POST, 'costumer_name', FILTER_SANITIZE_STRING);
                        $costumer_num = filter_input(INPUT_POST, 'costumer_num', FILTER_SANITIZE_STRING);
                        $costumer_email = filter_input(INPUT_POST, 'costumer_email', FILTER_SANITIZE_EMAIL);
                        $costumer_address = filter_input(INPUT_POST, 'costumer_address', FILTER_SANITIZE_STRING);
                        $employee_id = filter_input(INPUT_POST, 'employee_id', FILTER_SANITIZE_STRING);

                        try {
                            $stmt = $conn->prepare("INSERT INTO pelanggan (costumer_id, costumer_name, costumer_num, costumer_email, costumer_address, employee_id) VALUES (?, ?, ?, ?, ?, ?)");
                            $stmt->bind_param("ssssss", $costumer_id, $costumer_name, $costumer_num, $costumer_email, $costumer_address, $employee_id);

                            // Eksekusi statement
                            if ($stmt->execute()) {
                                echo 'Successfully Save Data';
                            } else {
                                throw new Exception("Failed Save Data: " . $stmt->error);
                            }
                        } catch (Exception $e) {
                            echo '<script>alert("' . $e->getMessage() . '")</script>';
                        }

                        // Tutup statement
                        $stmt->close();
                    }
                ?>
            </div>
        </div>
    </div>

    <!-- footer -->
    <footer>
        <div class="container">
            <small>Copyright &copy; 2023 - FIXIT.</small>
        </div>
    </footer>
</body>
</html>
